/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSXPathResult.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionIterateNext(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionSnapshotItem(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsXPathResultConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXPathResultConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsXPathResultResultType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultNumberValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultStringValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultBooleanValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultSingleNodeValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultInvalidIteratorState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsXPathResultSnapshotLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSXPathResultPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXPathResultPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXPathResultPrototype* ptr = new (NotNull, JSC::allocateCell<JSXPathResultPrototype>(vm.heap)) JSXPathResultPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXPathResultPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXPathResultPrototype, JSXPathResultPrototype::Base);

using JSXPathResultConstructor = JSDOMConstructorNotConstructable<JSXPathResult>;

/* Hash table for constructor */

static const HashTableValue JSXPathResultConstructorTableValues[] =
{
    { "ANY_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NUMBER_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "STRING_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "BOOLEAN_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "UNORDERED_NODE_ITERATOR_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "ORDERED_NODE_ITERATOR_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "ORDERED_NODE_SNAPSHOT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "ANY_UNORDERED_NODE_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "FIRST_ORDERED_NODE_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
};

static_assert(XPathResult::ANY_TYPE == 0, "ANY_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::NUMBER_TYPE == 1, "NUMBER_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::STRING_TYPE == 2, "STRING_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::BOOLEAN_TYPE == 3, "BOOLEAN_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::UNORDERED_NODE_ITERATOR_TYPE == 4, "UNORDERED_NODE_ITERATOR_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ORDERED_NODE_ITERATOR_TYPE == 5, "ORDERED_NODE_ITERATOR_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::UNORDERED_NODE_SNAPSHOT_TYPE == 6, "UNORDERED_NODE_SNAPSHOT_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ORDERED_NODE_SNAPSHOT_TYPE == 7, "ORDERED_NODE_SNAPSHOT_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::ANY_UNORDERED_NODE_TYPE == 8, "ANY_UNORDERED_NODE_TYPE in XPathResult does not match value from IDL");
static_assert(XPathResult::FIRST_ORDERED_NODE_TYPE == 9, "FIRST_ORDERED_NODE_TYPE in XPathResult does not match value from IDL");

template<> JSValue JSXPathResultConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXPathResultConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXPathResult::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("XPathResult"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSXPathResult::info(), JSXPathResultConstructorTableValues, *this);
}

template<> const ClassInfo JSXPathResultConstructor::s_info = { "XPathResult", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResultConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXPathResultPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXPathResultConstructor) } },
    { "resultType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultResultType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "numberValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultNumberValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "stringValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultStringValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "booleanValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultBooleanValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "singleNodeValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSingleNodeValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "invalidIteratorState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultInvalidIteratorState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "snapshotLength", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXPathResultSnapshotLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "iterateNext", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXPathResultPrototypeFunctionIterateNext), (intptr_t) (0) } },
    { "snapshotItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXPathResultPrototypeFunctionSnapshotItem), (intptr_t) (1) } },
    { "ANY_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NUMBER_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "STRING_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "BOOLEAN_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "UNORDERED_NODE_ITERATOR_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "ORDERED_NODE_ITERATOR_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(5) } },
    { "UNORDERED_NODE_SNAPSHOT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(6) } },
    { "ORDERED_NODE_SNAPSHOT_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(7) } },
    { "ANY_UNORDERED_NODE_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "FIRST_ORDERED_NODE_TYPE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(9) } },
};

const ClassInfo JSXPathResultPrototype::s_info = { "XPathResultPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResultPrototype) };

void JSXPathResultPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXPathResult::info(), JSXPathResultPrototypeTableValues, *this);
}

const ClassInfo JSXPathResult::s_info = { "XPathResult", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXPathResult) };

JSXPathResult::JSXPathResult(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XPathResult>&& impl)
    : JSDOMWrapper<XPathResult>(structure, globalObject, WTFMove(impl))
{
}

void JSXPathResult::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, XPathResult>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSXPathResult::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXPathResultPrototype::create(vm, &globalObject, JSXPathResultPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSXPathResult::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXPathResult>(vm, globalObject);
}

JSValue JSXPathResult::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXPathResultConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXPathResult::destroy(JSC::JSCell* cell)
{
    JSXPathResult* thisObject = static_cast<JSXPathResult*>(cell);
    thisObject->JSXPathResult::~JSXPathResult();
}

template<> inline JSXPathResult* IDLAttribute<JSXPathResult>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSXPathResult*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSXPathResult* IDLOperation<JSXPathResult>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSXPathResult*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsXPathResultConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXPathResultPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXPathResult::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSXPathResultConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXPathResultPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsXPathResultResultTypeGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.resultType());
    return result;
}

EncodedJSValue jsXPathResultResultType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultResultTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "resultType");
}

static inline JSValue jsXPathResultNumberValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.numberValue());
    return result;
}

EncodedJSValue jsXPathResultNumberValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultNumberValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "numberValue");
}

static inline JSValue jsXPathResultStringValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.stringValue());
    return result;
}

EncodedJSValue jsXPathResultStringValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultStringValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stringValue");
}

static inline JSValue jsXPathResultBooleanValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.booleanValue());
    return result;
}

EncodedJSValue jsXPathResultBooleanValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultBooleanValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "booleanValue");
}

static inline JSValue jsXPathResultSingleNodeValueGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.singleNodeValue());
    return result;
}

EncodedJSValue jsXPathResultSingleNodeValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultSingleNodeValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "singleNodeValue");
}

static inline JSValue jsXPathResultInvalidIteratorStateGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.invalidIteratorState());
    return result;
}

EncodedJSValue jsXPathResultInvalidIteratorState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultInvalidIteratorStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "invalidIteratorState");
}

static inline JSValue jsXPathResultSnapshotLengthGetter(JSGlobalObject& lexicalGlobalObject, JSXPathResult& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.snapshotLength());
    return result;
}

EncodedJSValue jsXPathResultSnapshotLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSXPathResult>::get<jsXPathResultSnapshotLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "snapshotLength");
}

static inline JSC::EncodedJSValue jsXPathResultPrototypeFunctionIterateNextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathResult>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.iterateNext()));
}

EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionIterateNext(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXPathResult>::call<jsXPathResultPrototypeFunctionIterateNextBody>(*lexicalGlobalObject, *callFrame, "iterateNext");
}

static inline JSC::EncodedJSValue jsXPathResultPrototypeFunctionSnapshotItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXPathResult>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.snapshotItem(WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsXPathResultPrototypeFunctionSnapshotItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXPathResult>::call<jsXPathResultPrototypeFunctionSnapshotItemBody>(*lexicalGlobalObject, *callFrame, "snapshotItem");
}

void JSXPathResult::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSXPathResult::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSXPathResult::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXPathResult*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXPathResultOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXPathResultOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXPathResult = static_cast<JSXPathResult*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXPathResult->wrapped(), jsXPathResult);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XPathResult>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XPathResult.
    static_assert(!std::is_polymorphic<XPathResult>::value, "XPathResult is polymorphic but the IDL claims it is not");
    return createWrapper<XPathResult>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XPathResult& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XPathResult* JSXPathResult::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXPathResult*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
