/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(XSLT)

#include "JSXSLTProcessor.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSDocumentFragment.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionImportStylesheet(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToFragment(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToDocument(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionSetParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionGetParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionRemoveParameter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionClearParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionReset(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsXSLTProcessorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSXSLTProcessorConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSXSLTProcessorPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSXSLTProcessorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSXSLTProcessorPrototype* ptr = new (NotNull, JSC::allocateCell<JSXSLTProcessorPrototype>(vm.heap)) JSXSLTProcessorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSXSLTProcessorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSXSLTProcessorPrototype, JSXSLTProcessorPrototype::Base);

using JSXSLTProcessorConstructor = JSDOMConstructor<JSXSLTProcessor>;

template<> EncodedJSValue JSC_HOST_CALL JSXSLTProcessorConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSXSLTProcessorConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto object = XSLTProcessor::create();
    return JSValue::encode(toJSNewlyCreated<IDLInterface<XSLTProcessor>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSXSLTProcessorConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSXSLTProcessorConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSXSLTProcessor::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("XSLTProcessor"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSXSLTProcessorConstructor::s_info = { "XSLTProcessor", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessorConstructor) };

/* Hash table for prototype */

static const HashTableValue JSXSLTProcessorPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsXSLTProcessorConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSXSLTProcessorConstructor) } },
    { "importStylesheet", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionImportStylesheet), (intptr_t) (0) } },
    { "transformToFragment", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToFragment), (intptr_t) (0) } },
    { "transformToDocument", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionTransformToDocument), (intptr_t) (0) } },
    { "setParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionSetParameter), (intptr_t) (3) } },
    { "getParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionGetParameter), (intptr_t) (2) } },
    { "removeParameter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionRemoveParameter), (intptr_t) (2) } },
    { "clearParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionClearParameters), (intptr_t) (0) } },
    { "reset", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsXSLTProcessorPrototypeFunctionReset), (intptr_t) (0) } },
};

const ClassInfo JSXSLTProcessorPrototype::s_info = { "XSLTProcessorPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessorPrototype) };

void JSXSLTProcessorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSXSLTProcessor::info(), JSXSLTProcessorPrototypeTableValues, *this);
}

const ClassInfo JSXSLTProcessor::s_info = { "XSLTProcessor", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSXSLTProcessor) };

JSXSLTProcessor::JSXSLTProcessor(Structure* structure, JSDOMGlobalObject& globalObject, Ref<XSLTProcessor>&& impl)
    : JSDOMWrapper<XSLTProcessor>(structure, globalObject, WTFMove(impl))
{
}

void JSXSLTProcessor::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, XSLTProcessor>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSXSLTProcessor::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSXSLTProcessorPrototype::create(vm, &globalObject, JSXSLTProcessorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSXSLTProcessor::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSXSLTProcessor>(vm, globalObject);
}

JSValue JSXSLTProcessor::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSXSLTProcessorConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSXSLTProcessor::destroy(JSC::JSCell* cell)
{
    JSXSLTProcessor* thisObject = static_cast<JSXSLTProcessor*>(cell);
    thisObject->JSXSLTProcessor::~JSXSLTProcessor();
}

template<> inline JSXSLTProcessor* IDLOperation<JSXSLTProcessor>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSXSLTProcessor*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsXSLTProcessorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXSLTProcessorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSXSLTProcessor::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSXSLTProcessorConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSXSLTProcessorPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionImportStylesheetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto stylesheet = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "stylesheet", "XSLTProcessor", "importStylesheet", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.importStylesheet(WTFMove(stylesheet));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionImportStylesheet(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionImportStylesheetBody>(*lexicalGlobalObject, *callFrame, "importStylesheet");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionTransformToFragmentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto source = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "XSLTProcessor", "transformToFragment", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto docVal = convert<IDLNullable<IDLInterface<Document>>>(*lexicalGlobalObject, callFrame->argument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "docVal", "XSLTProcessor", "transformToFragment", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DocumentFragment>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.transformToFragment(WTFMove(source), WTFMove(docVal))));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToFragment(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionTransformToFragmentBody>(*lexicalGlobalObject, *callFrame, "transformToFragment");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionTransformToDocumentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto source = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "XSLTProcessor", "transformToDocument", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Document>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.transformToDocument(WTFMove(source))));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionTransformToDocument(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionTransformToDocumentBody>(*lexicalGlobalObject, *callFrame, "transformToDocument");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionSetParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto value = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setParameter(WTFMove(namespaceURI), WTFMove(localName), WTFMove(value));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionSetParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionSetParameterBody>(*lexicalGlobalObject, *callFrame, "setParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionGetParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, impl.getParameter(WTFMove(namespaceURI), WTFMove(localName))));
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionGetParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionGetParameterBody>(*lexicalGlobalObject, *callFrame, "getParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionRemoveParameterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto namespaceURI = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto localName = convert<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeParameter(WTFMove(namespaceURI), WTFMove(localName));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionRemoveParameter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionRemoveParameterBody>(*lexicalGlobalObject, *callFrame, "removeParameter");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionClearParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearParameters();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionClearParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionClearParametersBody>(*lexicalGlobalObject, *callFrame, "clearParameters");
}

static inline JSC::EncodedJSValue jsXSLTProcessorPrototypeFunctionResetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSXSLTProcessor>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reset();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsXSLTProcessorPrototypeFunctionReset(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSXSLTProcessor>::call<jsXSLTProcessorPrototypeFunctionResetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

void JSXSLTProcessor::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSXSLTProcessor*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSXSLTProcessorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSXSLTProcessorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsXSLTProcessor = static_cast<JSXSLTProcessor*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsXSLTProcessor->wrapped(), jsXSLTProcessor);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<XSLTProcessor>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to XSLTProcessor.
    static_assert(!std::is_polymorphic<XSLTProcessor>::value, "XSLTProcessor is polymorphic but the IDL claims it is not");
    return createWrapper<XSLTProcessor>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, XSLTProcessor& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

XSLTProcessor* JSXSLTProcessor::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSXSLTProcessor*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(XSLT)
