/*
 * Copyright (c) 2015, 2016 Ericsson AB. All rights reserved.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "RTCPeerConnectionBuiltins.h"

#if ENABLE(WEB_RTC)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_rtcPeerConnectionInitializeRTCPeerConnectionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionInitializeRTCPeerConnectionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionInitializeRTCPeerConnectionCodeLength = 342;
static const JSC::Intrinsic s_rtcPeerConnectionInitializeRTCPeerConnectionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionInitializeRTCPeerConnectionCode =
    "(function (configuration)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (configuration == null)\n" \
    "        configuration = {};\n" \
    "    else if (!@isObject(configuration))\n" \
    "        @throwTypeError(\"RTCPeerConnection argument must be a valid dictionary\");\n" \
    "\n" \
    "    this.@initializeWith(configuration);\n" \
    "    @putByIdDirectPrivate(this, \"operations\", []);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionCreateOfferCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionCreateOfferCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionCreateOfferCodeLength = 308;
static const JSC::Intrinsic s_rtcPeerConnectionCreateOfferCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionCreateOfferCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isRTCPeerConnection(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"RTCPeerConnection\", \"createOffer\"));\n" \
    "\n" \
    "    const offerOptions = arguments[0];\n" \
    "    return @enqueueOperation(this, () => {\n" \
    "        return this.@queuedCreateOffer(offerOptions);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionCreateAnswerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionCreateAnswerCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionCreateAnswerCodeLength = 312;
static const JSC::Intrinsic s_rtcPeerConnectionCreateAnswerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionCreateAnswerCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isRTCPeerConnection(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"RTCPeerConnection\", \"createAnswer\"));\n" \
    "\n" \
    "    const answerOptions = arguments[0];\n" \
    "    return @enqueueOperation(this, () => {\n" \
    "        return this.@queuedCreateAnswer(answerOptions);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionSetLocalDescriptionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionSetLocalDescriptionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionSetLocalDescriptionCodeLength = 711;
static const JSC::Intrinsic s_rtcPeerConnectionSetLocalDescriptionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionSetLocalDescriptionCode =
    "(function (description)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isRTCPeerConnection(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"RTCPeerConnection\", \"setLocalDescription\"));\n" \
    "\n" \
    "    if (arguments.length < 1)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Not enough arguments\"));\n" \
    "\n" \
    "    //\n" \
    "    const objectInfo = {\n" \
    "        \"constructor\": @RTCSessionDescription,\n" \
    "        \"argName\": \"description\",\n" \
    "        \"argType\": \"RTCSessionDescription\",\n" \
    "        \"maybeDictionary\": \"true\"\n" \
    "    };\n" \
    "    return @objectOverload(description, \"setLocalDescription\", objectInfo, (description) => {\n" \
    "        return @enqueueOperation(this, () => {\n" \
    "            return this.@queuedSetLocalDescription(description);\n" \
    "        });\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionSetRemoteDescriptionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionSetRemoteDescriptionCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionSetRemoteDescriptionCodeLength = 714;
static const JSC::Intrinsic s_rtcPeerConnectionSetRemoteDescriptionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionSetRemoteDescriptionCode =
    "(function (description)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isRTCPeerConnection(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"RTCPeerConnection\", \"setRemoteDescription\"));\n" \
    "\n" \
    "    if (arguments.length < 1)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Not enough arguments\"));\n" \
    "\n" \
    "    //\n" \
    "    const objectInfo = {\n" \
    "        \"constructor\": @RTCSessionDescription,\n" \
    "        \"argName\": \"description\",\n" \
    "        \"argType\": \"RTCSessionDescription\",\n" \
    "        \"maybeDictionary\": \"true\"\n" \
    "    };\n" \
    "    return @objectOverload(description, \"setRemoteDescription\", objectInfo, (description) => {\n" \
    "        return @enqueueOperation(this, () => {\n" \
    "            return this.@queuedSetRemoteDescription(description);\n" \
    "        });\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_rtcPeerConnectionAddIceCandidateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_rtcPeerConnectionAddIceCandidateCodeConstructorKind = JSC::ConstructorKind::None;
const int s_rtcPeerConnectionAddIceCandidateCodeLength = 705;
static const JSC::Intrinsic s_rtcPeerConnectionAddIceCandidateCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_rtcPeerConnectionAddIceCandidateCode =
    "(function (candidate)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isRTCPeerConnection(this))\n" \
    "        return @Promise.@reject(@makeThisTypeError(\"RTCPeerConnection\", \"addIceCandidate\"));\n" \
    "\n" \
    "    if (arguments.length < 1)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Not enough arguments\"));\n" \
    "\n" \
    "    const objectInfo = {\n" \
    "        \"constructor\": @RTCIceCandidate,\n" \
    "        \"argName\": \"candidate\",\n" \
    "        \"argType\": \"RTCIceCandidate\",\n" \
    "        \"maybeDictionary\": \"true\",\n" \
    "        \"defaultsToNull\" : \"true\"\n" \
    "    };\n" \
    "    return @objectOverload(candidate, \"addIceCandidate\", objectInfo, (candidate) => {\n" \
    "        return @enqueueOperation(this, () => {\n" \
    "            return this.@queuedAddIceCandidate(candidate);\n" \
    "        });\n" \
    "    });\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().rtcPeerConnectionBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().rtcPeerConnectionBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_RTCPEERCONNECTION_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(WEB_RTC)
