/*
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2015 Igalia S.L.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2015, 2016 Canon Inc. All rights reserved.
 * Copyright (c) 2015, 2016 Ericsson AB. All rights reserved.
 * Copyright (c) 2015, 2016, 2017 Canon Inc.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Apple Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WebCoreJSBuiltinInternals.h"

#include "JSDOMGlobalObject.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/SlotVisitorInlines.h>
#include <JavaScriptCore/StructureInlines.h>

namespace WebCore {

JSBuiltinInternalFunctions::JSBuiltinInternalFunctions(JSC::VM& vm)
    : m_vm(vm)
#if ENABLE(WEB_RTC)
    , m_rtcPeerConnectionInternals(m_vm)
#endif // ENABLE(WEB_RTC)
#if ENABLE(STREAMS_API)
    , m_readableByteStreamInternals(m_vm)
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    , m_readableStreamInternals(m_vm)
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    , m_streamInternals(m_vm)
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    , m_writableStreamInternals(m_vm)
#endif // ENABLE(STREAMS_API)
    , m_jsDOMBindingInternals(m_vm)
{
    UNUSED_PARAM(vm);
}

void JSBuiltinInternalFunctions::visit(JSC::SlotVisitor& visitor)
{
#if ENABLE(WEB_RTC)
    m_rtcPeerConnectionInternals.visit(visitor);
#endif // ENABLE(WEB_RTC)
#if ENABLE(STREAMS_API)
    m_readableByteStreamInternals.visit(visitor);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_readableStreamInternals.visit(visitor);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_streamInternals.visit(visitor);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_writableStreamInternals.visit(visitor);
#endif // ENABLE(STREAMS_API)
    m_jsDOMBindingInternals.visit(visitor);
    UNUSED_PARAM(visitor);
}

void JSBuiltinInternalFunctions::initialize(JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(globalObject);
#if ENABLE(WEB_RTC)
    m_rtcPeerConnectionInternals.init(globalObject);
#endif // ENABLE(WEB_RTC)
#if ENABLE(STREAMS_API)
    m_readableByteStreamInternals.init(globalObject);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_readableStreamInternals.init(globalObject);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_streamInternals.init(globalObject);
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
    m_writableStreamInternals.init(globalObject);
#endif // ENABLE(STREAMS_API)
    m_jsDOMBindingInternals.init(globalObject);

#if ENABLE(WEB_RTC) || ENABLE(STREAMS_API)
    JSVMClientData& clientData = *static_cast<JSVMClientData*>(m_vm.clientData);
    JSDOMGlobalObject::GlobalPropertyInfo staticGlobals[] = {
#if ENABLE(WEB_RTC)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().rtcPeerConnectionInternalsBuiltins().name##PrivateName(), rtcPeerConnectionInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_RTCPEERCONNECTIONINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#endif // ENABLE(WEB_RTC)
#if ENABLE(STREAMS_API)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().readableByteStreamInternalsBuiltins().name##PrivateName(), readableByteStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().readableStreamInternalsBuiltins().name##PrivateName(), readableStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().streamInternalsBuiltins().name##PrivateName(), streamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#endif // ENABLE(STREAMS_API)
#if ENABLE(STREAMS_API)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().writableStreamInternalsBuiltins().name##PrivateName(), writableStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#endif // ENABLE(STREAMS_API)
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().jsDOMBindingInternalsBuiltins().name##PrivateName(), jsDOMBindingInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_JSDOMBINDINGINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
    };
    globalObject.addStaticGlobals(staticGlobals, WTF_ARRAY_LENGTH(staticGlobals));
    UNUSED_PARAM(clientData);
#endif // ENABLE(WEB_RTC) || ENABLE(STREAMS_API)
}

} // namespace WebCore
