/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WritableStreamBuiltins.h"

#if ENABLE(STREAMS_API)

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapInlines.h>
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSCJSValueInlines.h>
#include <JavaScriptCore/JSCellInlines.h>
#include <JavaScriptCore/StructureInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_writableStreamInitializeWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamInitializeWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamInitializeWritableStreamCodeLength = 1561;
static const JSC::Intrinsic s_writableStreamInitializeWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamInitializeWritableStreamCode =
    "(function (underlyingSink, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (underlyingSink === @undefined)\n" \
    "        underlyingSink = { };\n" \
    "    if (strategy === @undefined)\n" \
    "        strategy = { highWaterMark: 0, size: function() { return 1; } };\n" \
    "\n" \
    "    if (!@isObject(underlyingSink))\n" \
    "        @throwTypeError(\"WritableStream constructor takes an object as first argument\");\n" \
    "\n" \
    "    if (!@isObject(strategy))\n" \
    "        @throwTypeError(\"WritableStream constructor takes an object as second argument, if any\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"underlyingSink\", underlyingSink);\n" \
    "    @putByIdDirectPrivate(this, \"closedPromiseCapability\", @newPromiseCapability(@Promise));\n" \
    "    @putByIdDirectPrivate(this, \"readyPromiseCapability\", { @promise: @Promise.@resolve() });\n" \
    "    @putByIdDirectPrivate(this, \"queue\", @newQueue());\n" \
    "    @putByIdDirectPrivate(this, \"state\", @streamWritable);\n" \
    "    @putByIdDirectPrivate(this, \"started\", false);\n" \
    "    @putByIdDirectPrivate(this, \"writing\", false);\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"strategy\", @validateAndNormalizeQueuingStrategy(strategy.size, strategy.highWaterMark));\n" \
    "\n" \
    "    @syncWritableStreamStateWithQueue(this);\n" \
    "\n" \
    "    const errorFunction = (e) => {\n" \
    "        @errorWritableStream(this, e);\n" \
    "    };\n" \
    "    @putByIdDirectPrivate(this, \"startedPromise\", @promiseInvokeOrNoopNoCatch(underlyingSink, \"start\", [errorFunction]));\n" \
    "    @getByIdDirectPrivate(this, \"startedPromise\").@then(() => {\n" \
    "        @putByIdDirectPrivate(this, \"started\", true);\n" \
    "        @putByIdDirectPrivate(this, \"startedPromise\", @undefined);\n" \
    "    }, errorFunction);\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamAbortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamAbortCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamAbortCodeLength = 633;
static const JSC::Intrinsic s_writableStreamAbortCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamAbortCode =
    "(function (reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(@makeTypeError(\"The WritableStream.abort method can only be used on instances of WritableStream\"));\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(this, \"state\");\n" \
    "    if (state === @streamClosed)\n" \
    "        return @Promise.@resolve();\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(this, \"storedError\"));\n" \
    "\n" \
    "    @errorWritableStream(this, reason);\n" \
    "\n" \
    "    return @promiseInvokeOrFallbackOrNoop(@getByIdDirectPrivate(this, \"underlyingSink\"), \"abort\", [reason], \"close\", []).@then(function() { });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamCloseCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamCloseCodeLength = 922;
static const JSC::Intrinsic s_writableStreamCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamCloseCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(@makeTypeError(\"The WritableStream.close method can only be used on instances of WritableStream\"));\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(this, \"state\");\n" \
    "    if (state === @streamClosed || state === @streamClosing)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Cannot close a WritableString that is closed or closing\"));\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(this, \"storedError\"));\n" \
    "\n" \
    "    if (state === @streamWaiting)\n" \
    "        @getByIdDirectPrivate(this, \"readyPromiseCapability\").@resolve.@call();\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"state\", @streamClosing);\n" \
    "    @enqueueValueWithSize(@getByIdDirectPrivate(this, \"queue\"), \"close\", 0);\n" \
    "    @callOrScheduleWritableStreamAdvanceQueue(this);\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"closedPromiseCapability\").@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamWriteCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamWriteCodeLength = 1365;
static const JSC::Intrinsic s_writableStreamWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamWriteCode =
    "(function (chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(@makeTypeError(\"The WritableStream.write method can only be used on instances of WritableStream\"));\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(this, \"state\");\n" \
    "    if (state === @streamClosed || state === @streamClosing)\n" \
    "        return @Promise.@reject(@makeTypeError(\"Cannot write on a WritableString that is closed or closing\"));\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(this.@storedError);\n" \
    "\n" \
    "    @assert(state === @streamWritable || state === @streamWaiting);\n" \
    "\n" \
    "    let chunkSize = 1;\n" \
    "    if (@getByIdDirectPrivate(this, \"strategy\").size !== @undefined) {\n" \
    "        try {\n" \
    "            chunkSize = @getByIdDirectPrivate(this, \"strategy\").size.@call(@undefined, chunk);\n" \
    "        } catch(e) {\n" \
    "            @errorWritableStream(this, e);\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    const promiseCapability = @newPromiseCapability(@Promise);\n" \
    "    try {\n" \
    "        @enqueueValueWithSize(@getByIdDirectPrivate(this, \"queue\"), { promiseCapability: promiseCapability, chunk: chunk }, chunkSize);\n" \
    "    } catch (e) {\n" \
    "        @errorWritableStream(this, e);\n" \
    "        return @Promise.@reject(e);\n" \
    "    }\n" \
    "\n" \
    "    @syncWritableStreamStateWithQueue(this);\n" \
    "    @callOrScheduleWritableStreamAdvanceQueue(this);\n" \
    "\n" \
    "    return promiseCapability.@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamClosedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamClosedCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamClosedCodeLength = 231;
static const JSC::Intrinsic s_writableStreamClosedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamClosedCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(@makeGetterTypeError(\"WritableStream\", \"closed\"));\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"closedPromiseCapability\").@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamReadyCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamReadyCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamReadyCodeLength = 229;
static const JSC::Intrinsic s_writableStreamReadyCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamReadyCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        return @Promise.@reject(@makeGetterTypeError(\"WritableStream\", \"ready\"));\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"readyPromiseCapability\").@promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_writableStreamStateCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_writableStreamStateCodeConstructorKind = JSC::ConstructorKind::None;
const int s_writableStreamStateCodeLength = 513;
static const JSC::Intrinsic s_writableStreamStateCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_writableStreamStateCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isWritableStream(this))\n" \
    "        @throwTypeError(\"The WritableStream.state getter can only be used on instances of WritableStream\");\n" \
    "\n" \
    "    switch(@getByIdDirectPrivate(this, \"state\")) {\n" \
    "    case @streamClosed:\n" \
    "        return \"closed\";\n" \
    "    case @streamClosing:\n" \
    "        return \"closing\";\n" \
    "    case @streamErrored:\n" \
    "        return \"errored\";\n" \
    "    case @streamWaiting:\n" \
    "        return \"waiting\";\n" \
    "    case @streamWritable:\n" \
    "        return \"writable\";\n" \
    "    }\n" \
    "\n" \
    "    @assert(false);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().writableStreamBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().writableStreamBuiltins().codeName##Source(), WTF::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_WRITABLESTREAM_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore

#endif // ENABLE(STREAMS_API)
