/*
* Copyright (C) 2017-2019 Apple Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND ANY
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "config.h"
#include "ComplexTextController.h"

#if !USE(DIRECT2D)

#include "FontCache.h"
#include "FontCascade.h"

//+TELESCOPE_LIB_CHANGES
//4/7/2020
//PS platform support
#include <cassert>
//-TELESCOPE_LIB_CHANGES

namespace WebCore {
//+TELESCOPE_LIB_CHANGES
//4/7/2020
//PS platform support, remove some function here
//-TELESCOPE_LIB_CHANGES

template<typename T>
class BidiRange {
public:
    BidiRange(T* data, unsigned length, bool isLTR)
        : m_data(data)
        , m_length(length)
        , m_isLTR(isLTR)
    {
    }

    BidiRange(Vector<T>& data, bool isLTR)
        : m_data(data.data())
        , m_length(data.size())
        , m_isLTR(isLTR)
    {
    }

    class Iterator {
    public:
        Iterator(const BidiRange& range, unsigned logicalIndex)
            : m_range(range)
            , m_logicalIndex(logicalIndex)
        {
        }

        void operator++() { ++m_logicalIndex; }
        T& operator*() { return m_range.m_data[index()]; }
        bool operator==(const Iterator& other) { return m_logicalIndex == other.m_logicalIndex; }
        bool operator!=(const Iterator& other) { return m_logicalIndex != other.m_logicalIndex; }
        unsigned index()
        {
            ASSERT(m_logicalIndex < m_range.m_length);
            if (m_range.m_isLTR)
                return m_logicalIndex;
            return m_range.m_length - m_logicalIndex - 1;
        }

    private:
        friend BidiRange;

        const BidiRange& m_range;
        unsigned m_logicalIndex;
    };

    Iterator begin() const { return { *this, 0 }; }
    Iterator end() const { return { *this, m_length }; }

    Iterator fromIndex(unsigned index) const { return { *this, m_isLTR ? index : m_length - index - 1 }; }

private:
    T* m_data;
    unsigned m_length;
    bool m_isLTR;
};

//+TELESCOPE_LIB_CHANGES
//4/7/2020
//PS platform support, remove some function here
//-TELESCOPE_LIB_CHANGES
void ComplexTextController::collectComplexTextRunsForCharacters(const UChar* cp, unsigned stringLength, unsigned stringLocation, const Font* font)
{
//+TELESCOPE_LIB_CHANGES
//4/7/2020
//PS platform support
    assert(0);
//-TELESCOPE_LIB_CHANGES	
}

}

#endif // !USE(DIRECT2D)
