/*
 * Copyright (C) 2006-2008, 2013-2014 Apple Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//+TELESCOPE_LIB_CHANGES
//4/8/2020
//This file is copied from FontCacheWin.cpp, as this feature is not required
//So, stubs all functions here.
#include "config.h"
#include "Font.h"
#include "FontCache.h"
#include <wtf/HashSet.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/StdLibExtras.h>
#include <wtf/text/CString.h>
#include <wtf/text/StringHash.h>
#include <wtf/text/StringView.h>
#include <cassert>

using std::min;

//  TODO: we should have kept all assert there, cause we don't have an implementation of font for PlayStation

namespace WebCore
{

void FontCache::platformInit()
{
	//assert( 0 );
}

static const Vector<String>* getLinkedFonts(String& family)
{
    assert(0);
    return nullptr;
}

RefPtr<Font> FontCache::systemFallbackForCharacters(const FontDescription& description, const Font* originalFontData, IsForPlatformFont, PreferColoredFont, const UChar* characters, unsigned length)
{
    assert(0);
    return RefPtr<Font>();
}

Vector<String> FontCache::systemFontFamilies()
{
    assert(0);
    return Vector<String>();
}

bool FontCache::isSystemFontForbiddenForEditing(const String&)
{
    assert(0);
    return false;
}

Ref<Font> FontCache::lastResortFallbackFont(const FontDescription& fontDescription)
{
    //assert(0);
    FontPlatformData fontPlatformData;
    return fontForPlatformData(fontPlatformData);
}

struct TraitsInFamilyProcData {
    TraitsInFamilyProcData(const AtomString& familyName)
        : m_familyName(familyName)
    {
        assert(0);
    }

    const AtomString& m_familyName;
    Vector<FontSelectionCapabilities> m_capabilities;
};

Vector<FontSelectionCapabilities> FontCache::getFontSelectionCapabilitiesInFamily(const AtomString& familyName, AllowUserInstalledFonts)
{
    assert(0);
    return Vector<FontSelectionCapabilities>();
}

std::unique_ptr<FontPlatformData> FontCache::createFontPlatformData(const FontDescription& fontDescription, const AtomString& family, const FontFeatureSettings*, FontSelectionSpecifiedCapabilities)
{
    //assert(0);
    return std::unique_ptr<FontPlatformData>();
}

AtomString g_DummyAtomString;
const AtomString& FontCache::platformAlternateFamilyName(const AtomString& familyName)
{
    assert(0);
    return g_DummyAtomString;
}

}
//-TELESCOPE_LIB_CHANGES
