/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once
#if USE(TEXTURE_MAPPER_TELESCOPE)
#include "BitmapTexture.h"
#include "ClipStack.h"
#include "FilterOperations.h"
#define USE_WEBCORE_TYPE_CONVERTION_UTILITY
#include <Telescope/include/Render/HardwareRenderBase.h>
#undef USE_WEBCORE_TYPE_CONVERTION_UTILITY

namespace WebCore
{
class BitmapTextureTelescope : public BitmapTexture
{
   public:
	static Ref<BitmapTexture> createTexture(Telescope::HardwareRenderBase& render);
	static Ref<BitmapTexture> createRenderTarget(Telescope::HardwareRenderBase& render);

	IntSize size() const override;
	bool isValid() const override;
	void updateContents(Image* image, const IntRect& rect, const IntPoint& offset) override;
	void updateContents(const void*, const IntRect& target, const IntPoint& offset, int bytesPerLine) override;
	void didReset() override;
	RefPtr<BitmapTexture> applyFilters(TextureMapper&, const FilterOperations&) override;
	const FilterOperations* getFilters() const;
	void initializeStencil();
	Telescope::HardwareSurfaceBase* getSurface() const { return m_surface; };
	void bind();

	ClipStack& clipStack() { return m_clipstack; }

   private:
	BitmapTextureTelescope(Telescope::HardwareRenderBase& render, Telescope::HardwareSurfaceBase* surface);
	virtual ~BitmapTextureTelescope();

	Telescope::HardwareSurfaceBase* m_surface;
	Telescope::HardwareRenderBase& m_render;
	bool m_shouldClear = {true};
	bool m_clearedStencil = {false};
	ClipStack m_clipstack;
	std::unique_ptr<FilterOperations> m_filters;
};
}  // namespace WebCore
#endif	// #if USE(TEXTURE_MAPPER_TELESCOPE)