/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "config.h"
#include "wtf/Lock.h"
#include "wtf/HashMap.h"
#include "wtf/FastMalloc.h"
#include "wtf/text/WTFString.h"

enum CRECode
{
	CRECode_OK,
	CRECode_FAILED_INIT,
	CRECode_AGAIN,
	CRECode_RECV_ERROR,
	CRECode_TOO_MANY_REDIRECTS,
	CRECode_OPERATION_TIMEDOUT,
	CRECode_OUT_OF_MEMORY,
	CRECode_SSL_CACERT,
	CRECode_SSL_CONNECT_ERROR,
	CRECode_PEER_FAILED_VERIFICATION,
	CRECode_ADD_HEADER_ERROR,
	CRECode_LAST,
};

#define CTX_PAUSE_ALL        1
#define CTX_PAUSE_NONE       0

#define CTX_READFUNC_ABORT   0x10000000
#define CTX_WRITEFUNC_PAUSE  0x10000001

enum
{
	HTTP_VERSION_NONE,
	HTTP_VERSION_1_0,
	HTTP_VERSION_1_1,
	HTTP_VERSION_2_0,
};

namespace WebCore
{
	typedef void CURL;
	typedef size_t( *DataSendRecvCB )( char* ptr, size_t blockSize, size_t numberOfBlocks, void* userData );

	enum CurlAPIStatus
	{
		CURL_WAITING,
		CURL_WORKING,
		CURL_DONE,
		CURL_FAILED,
	};

	class CurlReplacement
	{
	public:
		virtual void* createContext() = 0;
		virtual void  destroyContext( void* context ) = 0;
		virtual bool  initRequest( void* context, const char* method, const char* url, const unsigned int timeout ) = 0; /*TELESCOPE_LIB_CHANGES 7/28/2020 change return type to bool for initRequest*/
		virtual void  addRequestHeader( void* context, const char* name, const char* value ) = 0;
		virtual void  removeRequestHeader( void* context, const char* name ) = 0;
		virtual void  perform( void* context ) = 0;
		virtual void  abort( void* context ) = 0;
		virtual void  finalize( void* context ) = 0;
		virtual long  getHttpVersion( void* context ) = 0;
		virtual void  setPause( void* context, bool enabled ) = 0;
		virtual bool  isPause( void* context ) = 0;
		virtual void  setSimpleUploadBuffer( void* context, const void* buffer, long size ) = 0;
		virtual int   getContentLength( void* context ) = 0;
		virtual void  setContentLength( void* context, int size ) = 0;
		virtual void  disableServerTrustEvaluation( void* context ) = 0;
		virtual void  setChunkedTransferEnabled( void* context, bool enabled ) = 0;
		virtual void  setHeaderReceiveCallback( void* context, DataSendRecvCB callback, void* userData ) = 0;
		virtual void  setDataReceiveCallback( void* context, DataSendRecvCB callback, void* userData ) = 0;
		virtual void  setDataSendCallback( void* context, DataSendRecvCB callback, void* userData ) = 0;
		virtual int   getStatus( void* context ) = 0;
		virtual int   getHttpStatus( void* context ) = 0;
		virtual int   getLastErrorCode( void* context ) = 0;
		virtual void  getUrl( void* context, const char** url ) = 0;

		virtual ~CurlReplacement() {}

		static const char* strError( int errorCode )
		{
			return "";
		}
	};
}

std::unique_ptr<WebCore::CurlReplacement> getCurlReplacementImplementation();
