/*
 * Copyright (C) 2006, 2007, 2013-2014 Apple Inc.  All rights reserved.
 * Copyright (C) 2013 Xueqing Huang <huangxueqing@baidu.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

//+TELESCOPE_LIB_CHANGES
//3/1/2020
//PS platform support
//This file is copied from PasteboardWin.cpp and stub functions
#include "config.h"
#include "Pasteboard.h"
#include "CachedImage.h"
#include "Color.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "Editor.h"
#include "Element.h"
#include "Frame.h"
#include "HTMLNames.h"
#include "HTMLParserIdioms.h"
#include "HitTestResult.h"
#include "Image.h"
#include "NotImplemented.h"
#include "Range.h"
#include "RenderImage.h"
#include "SharedBuffer.h"
#include "TextEncoding.h"
#include "WebCoreInstanceHandle.h"
#include "markup.h"
#include <wtf/Optional.h>
#include <wtf/URL.h>
#include <wtf/text/CString.h>
#include <wtf/text/StringView.h>

namespace WebCore {

std::unique_ptr<Pasteboard> Pasteboard::createForCopyAndPaste()
{
    notImplemented();
    return nullptr;
}

#if ENABLE(DRAG_SUPPORT)
std::unique_ptr<Pasteboard> Pasteboard::createForDragAndDrop()
{
    //COMPtr<WCDataObject> dataObject;
    //WCDataObject::createInstance(&dataObject);
    //return makeUnique<Pasteboard>(dataObject.get());
}

// static
std::unique_ptr<Pasteboard> Pasteboard::createForDragAndDrop(const DragData& dragData)
{
    //if (dragData.platformData())
    //    return makeUnique<Pasteboard>(dragData.platformData());
    //// FIXME: Should add a const overload of dragDataMap so we don't need a const_cast here.
    //return makeUnique<Pasteboard>(const_cast<DragData&>(dragData).dragDataMap());
}
#endif

Pasteboard::Pasteboard()
{
    notImplemented();
}


void Pasteboard::clear()
{
    notImplemented();
}

enum ClipboardDataType { ClipboardDataTypeNone, ClipboardDataTypeURL, ClipboardDataTypeText, ClipboardDataTypeTextHTML };


void Pasteboard::clear(const String& type)
{
    notImplemented();
}

bool Pasteboard::hasData()
{
    notImplemented();
    return false;
}

Vector<String> Pasteboard::typesSafeForBindings(const String&)
{
    notImplemented();
    return { };
}

Vector<String> Pasteboard::typesForLegacyUnsafeBindings()
{
    notImplemented();
    Vector<String> results;
    return results;
}

String Pasteboard::readOrigin()
{
    notImplemented();
    return { };
}

String Pasteboard::readString(const String& type)
{
    notImplemented();
    return "";
}

String Pasteboard::readStringInCustomData(const String&)
{
    notImplemented();
    return { };
}


Pasteboard::FileContentState Pasteboard::fileContentState()
{
    notImplemented();
    return FileContentState::MayContainFilePaths;
}

void Pasteboard::read(PasteboardFileReader& reader)
{
#if USE(CF)
    if (m_dataObject) {
        STGMEDIUM medium;
        if (FAILED(m_dataObject->GetData(cfHDropFormat(), &medium)))
            return;

        HDROP hdrop = reinterpret_cast<HDROP>(GlobalLock(medium.hGlobal));
        if (!hdrop)
            return;

        WCHAR filename[MAX_PATH];
        unsigned int fileCount = DragQueryFileW(hdrop, 0xFFFFFFFF, 0, 0);
        for (unsigned int i = 0; i < fileCount; i++) {
            if (!DragQueryFileW(hdrop, i, filename, WTF_ARRAY_LENGTH(filename)))
                continue;
            reader.readFilename(filename);
        }

        GlobalUnlock(medium.hGlobal);
        ReleaseStgMedium(&medium);
        return;
    }
    auto list = m_dragDataMap.find(cfHDropFormat()->cfFormat);
    if (list == m_dragDataMap.end())
        return;

    for (auto& filename : list->value)
        reader.readFilename(filename);
#else
    notImplemented();
    UNUSED_PARAM(reader);
    return;
#endif
}

void Pasteboard::writeString(const String& type, const String& data)
{
    notImplemented();
}

#if ENABLE(DRAG_SUPPORT)
void Pasteboard::setDragImage(DragImage, const IntPoint&)
{
    // Do nothing in Windows.
}
#endif

void Pasteboard::writePlainText(const String& text, SmartReplaceOption smartReplaceOption)
{
    notImplemented();
}

void Pasteboard::write(const PasteboardURL& pasteboardURL)
{
    notImplemented();
}

void Pasteboard::writeTrustworthyWebURLsPboardType(const PasteboardURL&)
{
    notImplemented();
}

bool Pasteboard::canSmartReplace()
{ 
    notImplemented();
    return false;
}

void Pasteboard::read(PasteboardPlainText& text, PlainTextURLReadingPolicy, Optional<size_t>)
{
    notImplemented();
}

void Pasteboard::write(const PasteboardWebContent&)
{
    notImplemented();
}

void Pasteboard::read(PasteboardWebContentReader&, WebContentReadingPolicy, Optional<size_t>)
{
    notImplemented();
}

void Pasteboard::write(const PasteboardImage&)
{
    notImplemented();
}

void Pasteboard::writeCustomData(const Vector<PasteboardCustomData>&)
{
    notImplemented();
}

void Pasteboard::write(const Color&)
{
    notImplemented();
}

void Pasteboard::writeMarkup( const String& markup )
{
    notImplemented();
}

} // namespace WebCore
//-TELESCOPE_LIB_CHANGES
