/*
 * Copyright (C) 2018 Sony Interactive Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//+TELESCOPE_LIB_CHANGES
//3/1/2020
//This file is copied from ScrollbarThemeWin.cpp for stub unnecessary file.
#include "config.h"
#include "ScrollbarThemeTelescope.h"

#include "HostWindow.h"
#include "NotImplemented.h"
#include "ScrollView.h"
#include "Scrollbar.h"

namespace WebCore {

ScrollbarTheme& ScrollbarTheme::nativeTheme()
{
    static ScrollbarThemeTelescope theme;
    return theme;
}

int ScrollbarThemeTelescope::scrollbarThickness(ScrollbarControlSize, ScrollbarExpansionState)
{
    return 7;
}

bool ScrollbarThemeTelescope::hasButtons(Scrollbar&)
{
    notImplemented();
    return true;
}

bool ScrollbarThemeTelescope::hasThumb(Scrollbar&)
{
    notImplemented();
    return true;
}

IntRect ScrollbarThemeTelescope::backButtonRect(Scrollbar&, ScrollbarPart, bool)
{
    notImplemented();
    return { };
}

IntRect ScrollbarThemeTelescope::forwardButtonRect(Scrollbar&, ScrollbarPart, bool)
{
    notImplemented();
    return { };
}

IntRect ScrollbarThemeTelescope::trackRect(Scrollbar& scrollbar, bool)
{
    return scrollbar.frameRect();
}

void ScrollbarThemeTelescope::paintTrackBackground(GraphicsContext& context, Scrollbar& scrollbar, const IntRect& trackRect)
{
    context.fillRect(trackRect, scrollbar.enabled() ? Color::lightGray : Color(0xFFE0E0E0));
}

void ScrollbarThemeTelescope::paintThumb(GraphicsContext& context, Scrollbar& scrollbar, const IntRect& thumbRect)
{
    if (scrollbar.enabled())
        context.fillRect(thumbRect, Color::darkGray);
}

} // namespace WebCore
//-TELESCOPE_LIB_CHANGES
