/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Redirect to following function within Telescope scope.
extern void LogDebug(const char*, const char*, va_list);
extern void LogInfo(const char*, const char*, va_list);
extern void LogWarning(const char*, const char*, va_list);
extern void LogError(const char*, const char*, va_list);

#ifdef __cplusplus
extern "C" {
#endif

	void WTFLog2(const WTFLogChannel& wtfChannel, WTFLogLevel level, const char* format, ...)
	{
		// This 'if' can skip the channels that are turned off earlier than the skip in log wrapper methods,
		// which also regards for this state for all WTF channels. So we should keep it.
		if (wtfChannel.state == WTFLogChannelState::Off)
			return;

		char channel[128];
		snprintf(channel, sizeof(channel), "%s.%s", wtfChannel.subsystem, wtfChannel.name);

		va_list args;
		va_start(args, format);

		switch (level)
		{
		case WTFLogLevel::Debug:
			LogDebug(channel, format, args);
			break;

		case WTFLogLevel::Always:
		case WTFLogLevel::Info:
			LogInfo(channel, format, args);
			break;

		case WTFLogLevel::Warning:
			LogWarning(channel, format, args);
			break;

		case WTFLogLevel::Error:
			LogError(channel, format, args);
			break;

		default:
			assert(0);
			break;
		}

		va_end(args);
	}

#ifdef __cplusplus
}
#endif
