/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "ClientWrappers/MemoryAllocatorBase.h"
#include "WebCore/CurlReplacement.h"
#include "ClientWrappers/HttpWrapperBase.h"

using namespace WebCore;

namespace Telescope
{
class CurlReplacementImpl : public CurlReplacement
{
	WTF_MAKE_FAST_ALLOCATED;

public:
	virtual void* createContext();
	virtual void  destroyContext( void* context );
	virtual bool  initRequest( void* context, const char* method, const char* url, const unsigned int timeout );
	virtual void  addRequestHeader( void* context, const char* name, const char* value );
	virtual void  removeRequestHeader( void* context, const char* name );
	virtual void  perform( void* context );
	virtual void  abort( void* context );
	virtual void  finalize( void* context );
	virtual long  getHttpVersion( void* context );
	virtual void  setPause( void* context, bool enabled );
	virtual bool  isPause( void* context );
	virtual void  setSimpleUploadBuffer(void* context, const void* buffer, long size);
	virtual int   getContentLength( void* context );
	virtual void  setContentLength( void* context, int size );
	virtual void  disableServerTrustEvaluation( void* context );
	virtual void  setChunkedTransferEnabled( void* context, bool enabled );
	virtual void  setHeaderReceiveCallback( void* context, DataSendRecvCB callback, void* userData );
	virtual void  setDataReceiveCallback( void* context, DataSendRecvCB callback, void* userData );
	virtual void  setDataSendCallback( void* context, DataSendRecvCB callback, void* userData );
	virtual int   getStatus( void* context );
	virtual int   getHttpStatus( void* context );
	virtual int   getLastErrorCode( void* context );
	virtual void  getUrl( void* context, const char** url );
	virtual ~CurlReplacementImpl();
};

void InstallHttpWrapper( HttpWrapperBase* httpWrapperImpl );
}

std::unique_ptr<WebCore::CurlReplacement> getCurlReplacementImplementation();
