/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ClientWrappers/CompressionWrapperBase.h"

CompressionWrapperBase* g_pCompressionWrapper = nullptr;

void InstallCompressionWrapper(CompressionWrapperBase* pCompressionWrapper )
{
	g_pCompressionWrapper = pCompressionWrapper;
}

CompressionWrapperBase* getCompressionWrapper()
{
	return g_pCompressionWrapper;
}

#if defined(__cplusplus)
extern "C"
{
#endif

	void wrapper_setCompressionWrapperMgr(CompressionWrapperBase* pCompressionWrapper )
	{
		g_pCompressionWrapper = pCompressionWrapper;
	}

	int wrapper_deflate( z_streamp strm, int flush )
	{
		return g_pCompressionWrapper->deflate( strm, flush );
	}

	int wrapper_deflateEnd( z_streamp strm )
	{
		return g_pCompressionWrapper->deflateEnd( strm );
	}

	gzFile wrapper_gzdopen( int fd, const char* mode )
	{
		return g_pCompressionWrapper->gzdopen( fd, mode );
	}

	int wrapper_gzread( gzFile file, voidp buf, unsigned len )
	{
		return g_pCompressionWrapper->gzread( file, buf, len );
	}

	int wrapper_gzwrite( gzFile file, voidpc buf, unsigned len )
	{
		return g_pCompressionWrapper->gzwrite( file, buf, len );
	}

	int wrapper_gzdirect( gzFile file )
	{
		return g_pCompressionWrapper->gzdirect( file );
	}

	int wrapper_gzclose( gzFile file )
	{
		return g_pCompressionWrapper->gzclose( file );
	}

	uLong wrapper_crc32( uLong crc, const Bytef* buf, uInt len )
	{
		return g_pCompressionWrapper->crc32( crc, buf, len );
	}

	int wrapper_deflateInit2_( z_streamp strm, int level, int method, int windowBits, int memLevel, int strategy )
	{
		return g_pCompressionWrapper->deflateInit2_( strm, level, method, windowBits, memLevel, strategy );
	}

	gzFile wrapper_gzopen( const char* path, const char* mode )
	{
		return g_pCompressionWrapper->gzopen( path, mode );
	}

	int wrapper_inflate( z_streamp z, int f )
	{
		return g_pCompressionWrapper->inflate( z, f );
	}

	int wrapper_inflateEnd( z_streamp z )
	{
		return g_pCompressionWrapper->inflateEnd( z );
	}

	int wrapper_inflateInit2_( z_streamp z, int w )
	{
		return g_pCompressionWrapper->inflateInit2_( z, w );
	}

	int wrapper_uncompress( Bytef* dest, uLongf* destLen, const Bytef* source, uLong sourceLen )
	{
		return g_pCompressionWrapper->uncompress( dest, destLen, source, sourceLen );
	}

	uLong wrapper_deflateBound( z_streamp strm, uLong sourceLen )
	{
		return g_pCompressionWrapper->deflateBound( strm, sourceLen );
	}

	int wrapper_inflateReset( z_streamp z )
	{
		return g_pCompressionWrapper->inflateReset( z );
	}

	int wrapper_deflateReset( z_streamp strm )
	{
		return g_pCompressionWrapper->deflateReset( strm );
	}

	int wrapper_inflateReset2( z_streamp strm, int windowBits )
	{
		return g_pCompressionWrapper->inflateReset2( strm, windowBits );
	}

	uLong wrapper_adler32( uLong adler, const Bytef* buf, uInt len )
	{
		return g_pCompressionWrapper->adler32( adler, buf, len );
	}

#if defined(__cplusplus)
};
#endif