/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "LogReplacement.h"
#include "wtf/TelescopePrintStream.h"
#include "wtf/Assertions.h"
#include "webcore/Logging.h"
#include "Universal/TelescopeLog.h"

namespace Telescope
{
	static LogWrapperBase* s_logWrapper = nullptr;

#if defined(WEBCORE_LOG_CHANNELS)
#define TELESCOPE_WEBKIT_LOGCHANNEL_CUSTOMSWITCH(name) \
    static bool CustomSwitch_ ## name(bool* newValue) \
	{ \
		WTFLogChannel& wtfChannel = WebCore::JOIN_LOG_CHANNEL_WITH_PREFIX(LOG_CHANNEL_PREFIX, name); \
		if(newValue) \
		{ \
			bool oldValue = wtfChannel.state == WTFLogChannelState::On; \
			wtfChannel.state = *newValue ? WTFLogChannelState::On : WTFLogChannelState::Off; \
			return oldValue; \
		} \
		else \
			return wtfChannel.state == WTFLogChannelState::On; \
	}

#define TELESCOPE_WEBKIT_REGISTER_LOGCHANNEL(name) \
	s_logWrapper->RegisterChannel( \
		LOG_CHANNEL_WEBKIT_SUBSYSTEM "." #name, \
		 CustomSwitch_ ## name);

#define TELESCOPE_WEBKIT_UNREGISTER_LOGCHANNEL(name) \
	s_logWrapper->UnregisterChannel(LOG_CHANNEL_WEBKIT_SUBSYSTEM "." #name);

	WEBCORE_LOG_CHANNELS(TELESCOPE_WEBKIT_LOGCHANNEL_CUSTOMSWITCH)
#endif

	void InstallLogWrapper( LogWrapperBase* logWrapperImpl )
	{
		s_logWrapper = logWrapperImpl;

		// Register Telescope log channel
		s_logWrapper->RegisterChannel(LogChannel::GENERAL, nullptr);

		// Register the 'misc' log channel
		s_logWrapper->RegisterChannel(LogChannel::MISC, nullptr);
	
		// Register the 'Console' log channel
		s_logWrapper->RegisterChannel(LogChannel::CONSOLE, nullptr);

#if defined(WEBCORE_LOG_CHANNELS)
		// Register all WebCore log channels
		WEBCORE_LOG_CHANNELS(TELESCOPE_WEBKIT_REGISTER_LOGCHANNEL)
#endif
	}

	// We needn't uninstall log because it have to work until the last moment (later than DLL detach and CRT atexit).
//	void UninstallLogWrapper()
//	{
//		if (!s_logWrapper)
//			return;
//
//		// Unregister Telescope log channel
//		s_logWrapper->UnregisterChannel(LogChannel::GENERAL);
//
//		// Unregister the 'misc' log channel
//		s_logWrapper->UnregisterChannel(LogChannel::MISC);
//
//		// Unregister the 'Console' log channel
//		s_logWrapper->UnregisterChannel(LogChannel::CONSOLE);
//
//#if defined(WEBCORE_LOG_CHANNELS)
//		// Unregister all WebCore log channels
//		WEBCORE_LOG_CHANNELS(TELESCOPE_WEBKIT_UNREGISTER_LOGCHANNEL)
//#endif
//
//		s_logWrapper = nullptr;
//	}

	LogWrapperBase* GetLogWrapper()
	{
		return s_logWrapper;
	}
}

#define TELESCOPE_DEFINE_LOG_METHOD(level) \
	void Log##level(const char* channelName, const char* format, va_list args) \
	{ \
		auto log = Telescope::GetLogWrapper(); \
		log->level(channelName, format, args); \
	}

TELESCOPE_DEFINE_LOG_METHOD(Debug)
TELESCOPE_DEFINE_LOG_METHOD(Info)
TELESCOPE_DEFINE_LOG_METHOD(Warning)
TELESCOPE_DEFINE_LOG_METHOD(Error)
TELESCOPE_DEFINE_LOG_METHOD(Fatal)
