/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "TelescopeJSGlobal.h"
#include "TelescopeJavascriptValue.h"

namespace Telescope
{
	JSC_Array* ValToArr( JSC_GlobalObject* pGlobalObject, JSC_Value* pVal )
	{
		if ( !pVal->isObject() || !pVal->getObject()->inherits( pGlobalObject->vm(), JSC_Array::info() ) )
			ASSERT_RETURN_NULLPTR

		return static_cast< JSC_Array* >( pVal->getObject() );
	}


	JSC_Object* ValToObj( JSC_Value* pVal )
	{
		if ( !pVal->isObject() )
			ASSERT_RETURN_NULLPTR

		return pVal->getObject();
	}


	JSC_Function* ValToFunc( JSC_Value* pVal )
	{
		if ( !pVal->isObject() || !pVal->getObject()->inherits( pVal->getObject()->vm(), JSC_Function::info() ) )
			ASSERT_RETURN_NULLPTR

		return static_cast< JSC_Function* >( pVal->getObject() );
	}
}

namespace JSC
{
	namespace Bindings
	{
		void JS2Telescope( JSGlobalObject* pGlobalObject, const JSValue& rValue, Telescope_Value* pOut )
		{
			JSLockHolder oLock( pGlobalObject );
			pOut->Assign( &rValue );
		}

		JSValue Telescope2JS( JSGlobalObject* pGlobalObject, const Telescope_Value& rValue )
		{
			JSLockHolder oLock( pGlobalObject );
			return *reinterpret_cast< JSC_Value* >( rValue.GetImpl() );
		}
	}
}