/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "TelescopeSurface.h"

namespace Telescope
{
Surface::Surface( SurfacePixelFormat format )
	: mData(nullptr), mWidth(0), mHeight(0), mFormat(format)
{ // Nothing to do here.
}

Surface::~Surface()
{
	mData = nullptr;
	mWidth = 0;
	mHeight = 0;
	mFormat = SurfacePixelFormat::PixelFormatSupportCount;
}

int Surface::getDataSize()
{
	return mWidth * mHeight * bytesPerPixel( mFormat );
}

void Surface::setSize( int w, int h )
{
	reset();
	mWidth = w;
	mHeight = h;
	mData = Telescope_GetMemoryAllocator()->Allocate( getDataSize(), SURFACE_MEMORY_TAG );
}

void Surface::reset()
{
	Telescope_GetMemoryAllocator()->Deallocate( mData );
	mData = nullptr;
}

void Surface::getData( SurfaceDescriptor& descriptor, const SurfaceRegion* region )
{
	ASSERT(mData != nullptr);
	const int bpp = bytesPerPixel( mFormat );
	descriptor.stride = mWidth * bpp;
	descriptor.pixelFormat = mFormat;
	if ( region )
	{
		descriptor.data = (char*)mData + region->mx * bpp + region->my	* descriptor.stride;
		descriptor.width = region->mWidth;
		descriptor.height = region->mHeight;
	}
	else
	{
		descriptor.data = mData;
		descriptor.width = mWidth;
		descriptor.height = mHeight;
	}
}
}
