/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef  __TELESCOPE_ASSERT_H__
#define __TELESCOPE_ASSERT_H__

#include "PlatformFeatureDefs.h"

#if TELESCOPE_USING(TELESCOPE_FEATURE_ASSERT)
#define TELESCOPE_ASSERT(expression)                         if(!(expression)) WTFReportAssertionFailure(__FILE__, __LINE__, "", #expression);
#define TELESCOPE_ASSERT_MSG(expression, message)            if(!(expression)) WTFReportAssertionFailure(__FILE__, __LINE__, "", message);
#define TELESCOPE_ASSERT_FORMATTED(expression, format, ...)  if(!(expression)) WTFReportAssertionFailureWithMessage(__FILE__, __LINE__, "", #expression, format, __VA_ARGS__);
#define TELESCOPE_FAIL_MSG(message)                          WTFReportAssertionFailure(__FILE__, __LINE__, "", message)
#define TELESCOPE_FAIL_FORMATTED(format, ...)                WTFReportAssertionFailureWithMessage(__FILE__, __LINE__, "", "Assert Failure", format, __VA_ARGS__)
#else
#define TELESCOPE_ASSERT(expression)                         ((void)0)
#define TELESCOPE_ASSERT_MSG(expression, message)            ((void)0)
#define TELESCOPE_ASSERT_FORMATTED(expression, ...)          ((void)0)
#define TELESCOPE_FAIL_MSG(message)                          ((void)0)
#define TELESCOPE_FAIL_FORMATTED(format, ...)                ((void)0)
#endif // #if TELESCOPE_USING(TELESCOPE_FEATURE_ASSERT )

#endif // #ifndef  __TELESCOPE_ASSERT_H__
