/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "PlatformFeatureDefs.h"

#if TELESCOPE_USING(TELESCOPE_PC_PROGRAM)
#include <windows.h>
#include "WebCore/Frame.h"

using namespace WebCore;

namespace Telescope
{
	class WebView;

	class IMMDict {
		typedef HIMC( CALLBACK* getContextPtr )( HWND );
		typedef BOOL( CALLBACK* releaseContextPtr )( HWND, HIMC );
		typedef LONG( CALLBACK* getCompositionStringPtr )( HIMC, DWORD, LPVOID, DWORD );
		typedef BOOL( CALLBACK* setCandidateWindowPtr )( HIMC, LPCANDIDATEFORM );
		typedef BOOL( CALLBACK* setOpenStatusPtr )( HIMC, BOOL );
		typedef BOOL( CALLBACK* notifyIMEPtr )( HIMC, DWORD, DWORD, DWORD );
		typedef BOOL( CALLBACK* associateContextExPtr )( HWND, HIMC, DWORD );

	public:
		getContextPtr getContext;
		releaseContextPtr releaseContext;
		getCompositionStringPtr getCompositionString;
		setCandidateWindowPtr setCandidateWindow;
		setOpenStatusPtr setOpenStatus;
		notifyIMEPtr notifyIME;
		associateContextExPtr associateContextEx;

		static const IMMDict& dict();
	private:
		IMMDict();
		HMODULE m_instance;
	};


	class ViewIME
	{
	public:
		ViewIME();
		~ViewIME();

		bool onIMEStartComposition( WebView* wv );
		bool onIMEComposition( WebView* wv, LPARAM lParam );
		bool onIMEEndComposition( WebView* wv );
		bool onIMEChar( WebView* wv, WPARAM wParam, LPARAM lParam );
		bool onIMENotify( WebView* wv, WPARAM wParam, LPARAM lParam, LRESULT* pRlt );
		LRESULT onIMERequest( WebView* wv, WPARAM wParam, LPARAM lParam );
		bool onIMESelect( WebView* wv, WPARAM wParam, LPARAM lParam );
		bool onIMESetContext( WebView* wv, WPARAM wParam, LPARAM lParam );

		HIMC getIMMContext();
		void releaseIMMContext( HIMC );
		void prepareCandidateWindow( Frame* targetFrame, HIMC hInputContext );

		LRESULT onIMERequestCharPosition( WebCore::Frame*, IMECHARPOSITION* );
		LRESULT onIMERequestReconvertString( WebCore::Frame*, RECONVERTSTRING* );

		float ViewIME::deviceScaleFactor() const;

		void SetViewWnd(HWND wnd);

	protected:
	private:
		float m_customDeviceScaleFactor{ 0 };
		unsigned m_inIMEComposition{ 0 };
		HWND m_viewWindow{ nullptr };
		//HWND m_hostWindow{ nullptr };
	};
};
#endif