/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#if USE(TEXTURE_MAPPER_TELESCOPE)
#include <WebCore/GraphicsLayer.h>
#include <WebCore/GraphicsLayerClient.h>
#include <webcore/TextureMapper.h>
#include "render/HardwareRenderBase.h"
namespace Telescope
{
class WebView;

class AcceleratedCompositingContext : public WebCore::GraphicsLayerClient
{
	WTF_MAKE_FAST_ALLOCATED;
	WTF_MAKE_NONCOPYABLE(AcceleratedCompositingContext);

   public:
	explicit AcceleratedCompositingContext(Telescope::WebView&, HardwareRenderBase& render);
	virtual ~AcceleratedCompositingContext();

	void setRootCompositingLayer(WebCore::GraphicsLayer*);
	void setNonCompositedContentsNeedDisplay(const WebCore::IntRect&);
	void resizeRootLayer(const WebCore::IntSize&);

	void paintContents(const WebCore::GraphicsLayer*,
					   WebCore::GraphicsContext&,
					   const WebCore::FloatRect&,
					   WebCore::GraphicsLayerPaintBehavior) override;
	float deviceScaleFactor() const override;
	void scrollNonCompositedContents(const WebCore::IntRect&, const WebCore::IntSize&);
	const HardwareSurfaceBase* getRenderSurface();
	void flushPendingLayerChangesSoon();
	void flushAndRenderLayers();

   private:
	bool enabled();
	void initialize();
	void compositeLayersToContext();
	bool flushPendingLayerChanges();
	bool prepareForRendering();
	void applyDeviceScaleFactor();
	void doSetRootCompositingLayer(WebCore::GraphicsLayer*);
	bool startedAnimation(WebCore::GraphicsLayer*);
	void updateRenderSurfaceIfNeeded();

	Telescope::WebView& m_webView;
	HardwareRenderBase& m_render;

	RefPtr<WebCore::GraphicsLayer> m_rootLayer;
	RefPtr<WebCore::GraphicsLayer> m_nonCompositedContentLayer;
	WebCore::TextureMapper* m_textureMapper = nullptr;

	HardwareSurfaceBase* m_surface = nullptr;
	WebCore::GraphicsLayer* m_targetGraphicsLayer = nullptr;
	bool m_targetGraphicsLayerDirty = false;
	bool m_pendingLayerChange = false;
};
};	// namespace Telescope

#endif	// #if USE(TEXTURE_MAPPER_TELESCOPE)
