/*
 * Copyright (C) 2006-2017 Apple Inc. All rights reserved.
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WebChromeClient.h"

#include "WebView.h"
#include <WebCore/BString.h>
#include <WebCore/ContextMenu.h>
#include <WebCore/Cursor.h>
#include <WebCore/FileChooser.h>
#include <WebCore/FileIconLoader.h>
#include <WebCore/FloatRect.h>
#include <WebCore/Frame.h>
#include <WebCore/FrameLoadRequest.h>
#include <WebCore/FrameView.h>
#include <WebCore/FullScreenController.h>
#include <WebCore/FullscreenManager.h>
#include <WebCore/GraphicsLayer.h>
#include <WebCore/HTMLNames.h>
#include <WebCore/HTMLVideoElement.h>
#include <WebCore/Icon.h>
#include <WebCore/LocalizedStrings.h>
#include <WebCore/NavigationAction.h>
#include <WebCore/NotImplemented.h>
#include <WebCore/Page.h>
#include <WebCore/SecurityOrigin.h>
#include <WebCore/WindowFeatures.h>
#include <wchar.h>
#include "Universal/TelescopeLog.h"

using namespace WebCore;
using namespace Telescope;

WebChromeClient::WebChromeClient(WebView* webView)
    : m_webView(webView)
#if ENABLE(NOTIFICATIONS)
    , m_notificationsDelegate(makeUnique<WebDesktopNotificationsDelegate>(webView))
#endif
{
}

void WebChromeClient::chromeDestroyed()
{
    delete this;
}

void WebChromeClient::setWindowRect(const FloatRect& r)
{
    notImplemented();
}

FloatRect WebChromeClient::windowRect()
{
    return *m_webView->windowRect();
}

FloatRect WebChromeClient::pageRect()
{
    return *m_webView->windowRect();
}

void WebChromeClient::focus()
{
}

void WebChromeClient::unfocus()
{
}

bool WebChromeClient::canTakeFocus(FocusDirection direction)
{
    return false;
}

void WebChromeClient::takeFocus(FocusDirection direction)
{
    notImplemented();
}

void WebChromeClient::focusedElementChanged(Element*)
{
}

void WebChromeClient::focusedFrameChanged(Frame*)
{
}

Page* WebChromeClient::createWindow(Frame& frame, const FrameLoadRequest&, const WindowFeatures& features, const NavigationAction& navigationAction)
{
    notImplemented();
    return nullptr;
}

void WebChromeClient::show()
{
    return;
}

bool WebChromeClient::canRunModal()
{
    return false;
}

void WebChromeClient::runModal()
{

}

void WebChromeClient::setToolbarsVisible(bool visible)
{
}

bool WebChromeClient::toolbarsVisible()
{
    return false;
}

void WebChromeClient::setStatusbarVisible(bool visible)
{

}

bool WebChromeClient::statusbarVisible()
{
    return false;
}

void WebChromeClient::setScrollbarsVisible(bool b)
{
}

bool WebChromeClient::scrollbarsVisible()
{
    return false;
}

void WebChromeClient::setMenubarVisible(bool visible)
{
}

bool WebChromeClient::menubarVisible()
{
    return false;
}

void WebChromeClient::setResizable(bool resizable)
{
    notImplemented();
}

void WebChromeClient::addMessageToConsole(MessageSource source, MessageLevel level, const String& message, unsigned lineNumber, unsigned columnNumber, const String& url)
{
//+TELESCOPE_LIB_CHANGES
// 9/ 15/2020 Print console log to Telescope log channel
	static const char* messageSources[] = {
		"XML", 
        "JS",
        "Network",
        "ConsoleAPI",
        "Storage",
        "AppCache",
        "Rendering",
		"CSS",
        "Security",
        "ContentBlocker",
        "Other",
        "Media",
        "WebRTC",
        "MediaSource",
	};
	static_assert(ARRAY_SIZE(messageSources) == static_cast<int>(MessageSource::Count));

	auto logFunc = &Telescope::LogInfo;
	switch (level)
	{
		case MessageLevel::Log:
			logFunc = &Telescope::LogInfo;
			break;
		case MessageLevel::Warning:
			logFunc = &Telescope::LogWarning;
			break;
		case MessageLevel::Error:
			logFunc = &Telescope::LogError;
			break;
		case MessageLevel::Debug:
			logFunc = &Telescope::LogDebug;
			break;
		case MessageLevel::Info:
			logFunc = &Telescope::LogInfo;
			break;
		default:
			assert(false);
			break;
	}

	int sourceIndex = static_cast<int>(source);
	logFunc(Telescope::LogChannel::CONSOLE, "[%s]: %s @%s line:%d column:%d", messageSources[sourceIndex], message.ascii().data(), url.ascii().data(),
			lineNumber, columnNumber);
//-TELESCOPE_LIB_CHANGES
}

bool WebChromeClient::canRunBeforeUnloadConfirmPanel()
{
    return true;
}

bool WebChromeClient::runBeforeUnloadConfirmPanel(const String& message, Frame& frame)
{
    return true;
}

void WebChromeClient::closeWindowSoon()
{
    // We need to remove the parent WebView from WebViewSets here, before it actually
    // closes, to make sure that JavaScript code that executes before it closes
    // can't find it. Otherwise, window.open will select a closed WebView instead of 
    // opening a new one <rdar://problem/3572585>.

    // We also need to stop the load to prevent further parsing or JavaScript execution
    // after the window has torn down <rdar://problem/4161660>.
  
    // FIXME: This code assumes that the UI delegate will respond to a webViewClose
    // message by actually closing the WebView. Safari guarantees this behavior, but other apps might not.
    // This approach is an inherent limitation of not making a close execute immediately
    // after a call to window.close.


    /*m_webView->setGroupName(0);
    m_webView->stopLoading(0);
    m_webView->closeWindowSoon();*/
    
}

void WebChromeClient::runJavaScriptAlert(Frame&, const String& message)
{
    notImplemented();
}

bool WebChromeClient::runJavaScriptConfirm(Frame&, const String& message)
{
    notImplemented();
    return true;
}

bool WebChromeClient::runJavaScriptPrompt(Frame&, const String& message, const String& defaultValue, String& result)
{
    return true;
}

void WebChromeClient::setStatusbarText(const String& statusText)
{

}

KeyboardUIMode WebChromeClient::keyboardUIMode()
{
    return KeyboardAccessTabsToLinks;
}

void WebChromeClient::invalidateRootView(const IntRect& windowRect)
{
    notImplemented();
}

void WebChromeClient::invalidateContentsAndRootView(const IntRect& windowRect)
{
	assert( m_webView );
	if ( m_webView )
	{
		m_webView->AddDirtyRegion( &windowRect );
	}
}

void WebChromeClient::invalidateContentsForSlowScroll(const IntRect& windowRect)
{
    invalidateContentsAndRootView( windowRect );
}

void WebChromeClient::scroll(const IntSize& delta, const IntRect& scrollViewRect, const IntRect& clipRect)
{
    invalidateContentsAndRootView( clipRect );
}

IntPoint WebChromeClient::accessibilityScreenToRootView(const WebCore::IntPoint& point) const
{
    return screenToRootView(point);
}

IntRect WebChromeClient::rootViewToAccessibilityScreen(const WebCore::IntRect& rect) const
{
    return rootViewToScreen(rect);
}

IntRect WebChromeClient::rootViewToScreen(const IntRect& rect) const
{
    return rect;
}

IntPoint WebChromeClient::screenToRootView(const IntPoint& point) const
{
    return point;
}

PlatformPageClient WebChromeClient::platformPageClient() const
{
    return nullptr;
}

void WebChromeClient::contentsSizeChanged(Frame&, const IntSize&) const
{
    notImplemented();
}

void WebChromeClient::intrinsicContentsSizeChanged(const IntSize&) const
{
    notImplemented();
}

void WebChromeClient::mouseDidMoveOverElement(const HitTestResult& result, unsigned modifierFlags, const String& toolTip, TextDirection)
{
    notImplemented();
}

bool WebChromeClient::shouldUnavailablePluginMessageBeButton(RenderEmbeddedObject::PluginUnavailabilityReason pluginUnavailabilityReason) const
{
    return false;
}

void WebChromeClient::unavailablePluginButtonClicked(Element& element, RenderEmbeddedObject::PluginUnavailabilityReason pluginUnavailabilityReason) const
{
    notImplemented();
}

void WebChromeClient::print(Frame& frame)
{

}

void WebChromeClient::exceededDatabaseQuota(Frame& frame, const String& databaseIdentifier, DatabaseDetails)
{
    notImplemented();
}

// FIXME: Move this include to the top of the file with the other includes.
#include <WebCore/ApplicationCacheStorage.h>

void WebChromeClient::reachedMaxAppCacheSize(int64_t spaceNeeded)
{
    // FIXME: Free some space.
    notImplemented();
}

void WebChromeClient::reachedApplicationCacheOriginQuota(SecurityOrigin&, int64_t)
{
    notImplemented();
}

void WebChromeClient::runOpenPanel(Frame&, FileChooser& fileChooser)
{
    notImplemented();
}

void WebChromeClient::loadIconForFiles(const Vector<WTF::String>& filenames, WebCore::FileIconLoader& loader)
{
}

RefPtr<Icon> WebChromeClient::createIconForFiles(const Vector<String>& filenames)
{
    return nullptr;
}

void WebChromeClient::didFinishLoadingImageForElement(WebCore::HTMLImageElement&)
{
}

void WebChromeClient::setCursor(const Cursor& cursor)
{
}

void WebChromeClient::setCursorHiddenUntilMouseMoves(bool)
{
    notImplemented();
}

#if PLATFORM(WIN)
void WebChromeClient::setLastSetCursorToCurrentCursor()
{
}
#endif

void WebChromeClient::attachRootGraphicsLayer(Frame&, GraphicsLayer* graphicsLayer)
{
    m_webView->SetRootChildLayer( graphicsLayer );
}

void WebChromeClient::attachViewOverlayGraphicsLayer(GraphicsLayer*)
{
    // FIXME: If we want view-relative page overlays in Legacy WebKit on Windows, this would be the place to hook them up.
}

void WebChromeClient::scheduleCompositingLayerFlush()
{
    m_webView->flushPendingGraphicsLayerChangesSoon();
}

#if PLATFORM(WIN) && USE(AVFOUNDATION)
WebCore::GraphicsDeviceAdapter* WebChromeClient::graphicsDeviceAdapter() const
{
    return nullptr;
}
#endif

#if ENABLE(VIDEO)

bool WebChromeClient::supportsVideoFullscreen(HTMLMediaElementEnums::VideoFullscreenMode)
{
    return true;
}

void WebChromeClient::enterVideoFullscreenForVideoElement(HTMLVideoElement& videoElement, HTMLMediaElementEnums::VideoFullscreenMode, bool)
{
    m_webView->enterVideoFullscreenForVideoElement(videoElement);
}

void WebChromeClient::exitVideoFullscreenForVideoElement(HTMLVideoElement& videoElement)
{
    m_webView->exitVideoFullscreenForVideoElement(videoElement);
}

#endif

bool WebChromeClient::selectItemWritingDirectionIsNatural()
{
    return false;
}

bool WebChromeClient::selectItemAlignmentFollowsMenuWritingDirection()
{
    return true;
}

RefPtr<PopupMenu> WebChromeClient::createPopupMenu(PopupMenuClient& client) const
{
    return nullptr;
}

RefPtr<SearchPopupMenu> WebChromeClient::createSearchPopupMenu(PopupMenuClient& client) const
{
    return nullptr;
}

#if ENABLE(FULLSCREEN_API)

bool WebChromeClient::supportsFullScreenForElement(const Element& element, bool requestingKeyboardAccess)
{
    return false;
}

void WebChromeClient::enterFullScreenForElement(Element& element)
{
}

void WebChromeClient::exitFullScreenForElement(Element* element)
{
}
#endif

#if PLATFORM(WIN)
void WebChromeClient::AXStartFrameLoad()
{
}

void WebChromeClient::AXFinishFrameLoad()
{

}
#endif

bool WebChromeClient::shouldUseTiledBackingForFrameView(const FrameView& frameView) const
{
#if !USE(CAIRO)
    return frameView.frame().isMainFrame();
#else
    return false;
#endif
}
