/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

namespace Telescope
{
	class HashingWrapperBase
	{
	public:
		virtual void* SHA1_Create() = 0;
		virtual int   SHA1_Init( void* context ) = 0;
		virtual int   SHA1_Update( void* context, const void* data, size_t len ) = 0;
		virtual int   SHA1_Final( unsigned char* md, void* context ) = 0;
		virtual void  SHA1_Destroy( void* context ) = 0;

		virtual void* SHA224_Create() = 0;
		virtual int   SHA224_Init( void* context ) = 0;
		virtual int   SHA224_Update( void* context, const void* data, size_t len ) = 0;
		virtual int   SHA224_Final( unsigned char* md, void* context ) = 0;
		virtual void  SHA224_Destroy( void* context ) = 0;

		virtual void* SHA256_Create() = 0;
		virtual int   SHA256_Init( void* context ) = 0;
		virtual int   SHA256_Update( void* context, const void* data, size_t len ) = 0;
		virtual int   SHA256_Final( unsigned char* md, void* context ) = 0;
		virtual void  SHA256_Destroy( void* context ) = 0;

		virtual void* SHA384_Create() = 0;
		virtual int   SHA384_Init( void* context ) = 0;
		virtual int   SHA384_Update( void* context, const void* data, size_t len ) = 0;
		virtual int   SHA384_Final( unsigned char* md, void* context ) = 0;
		virtual void  SHA384_Destroy( void* context ) = 0;

		virtual void* SHA512_Create() = 0;
		virtual int   SHA512_Init( void* context ) = 0;
		virtual int   SHA512_Update( void* context, const void* data, size_t len ) = 0;
		virtual int   SHA512_Final( unsigned char* md, void* context ) = 0;
		virtual void  SHA512_Destroy( void* context ) = 0;

		virtual ~HashingWrapperBase() {}
	};
}
