/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

namespace Telescope
{
	class SystemAPIWrapperBase
	{
	public:
		virtual ~SystemAPIWrapperBase() {}

		virtual void threadYield() = 0;
		virtual int GetCurrentThreadId() = 0;
		virtual void usleep( unsigned int microseconds ) = 0;
		virtual uint16_t netHtons( uint16_t host16 ) = 0;
		virtual uint32_t netHtonl( uint32_t host32 ) = 0;
		virtual uint32_t netNtohl( uint32_t net32 ) = 0;

		// Only PS requires these hidden APIs
#ifdef IS_PS
		// +File System
		enum class TelescopeFileSeekOrigin
		{
			Beginning,
			Current,
			End,
		};

		enum class TelescopeFileOpenMode {
			Read,
			Write,
		};

		typedef int PlatformFileHandle;
		const PlatformFileHandle invalidPlatformFileHandle = -1;
		typedef void (*DirectoryFileCB)(const void* const pBackParameters, const char* pFileName);

		virtual bool mkdir(const char* path) = 0;
		virtual bool getFileSize(const char* path, long long& outSize) = 0;
		virtual bool getFileSize(PlatformFileHandle fileHandle, long long& outSize) = 0;
		virtual bool getFileModificationTime(const char* path, time_t &outSeconds) = 0;
		virtual bool getFileCreationTime(const char* path, time_t& outSeconds) = 0;
		virtual bool fileExists(const char* path) = 0;
		virtual bool deleteFile(const char* path) = 0;
		virtual bool deleteEmptyDirectory(const char* path) = 0;
		virtual bool moveFile(const char* oldPath, const char* newPath) = 0;
		virtual bool openFile(const char* path, TelescopeFileOpenMode mode, PlatformFileHandle&outFileHandle) = 0;
		virtual bool closeFile(PlatformFileHandle& handle) = 0;
		virtual long long seekFile(PlatformFileHandle handle, long long offset, TelescopeFileSeekOrigin origin) = 0;
		virtual bool truncateFile(PlatformFileHandle fileHandle, long long offset) = 0;
		virtual int writeToFile(PlatformFileHandle handle, const char* data, int length) = 0;
		virtual int readFromFile(PlatformFileHandle handle, char* outData, int length) = 0;
		virtual void walkDirectoryFiles(PlatformFileHandle handle, const void* const pBackParameters, DirectoryFileCB pFun) = 0;
		// -File System
#endif // #ifdef IS_PS
	};
}
