/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#define __TELESCOPE_IN_USE__ 9
#define __TELESCOPE_NOT_IN_USE__ (-__TELESCOPE_IN_USE__)

#define __TELESCOPE_USE_IF__(x) ( ( x ) ? 9 : -9 )
#define TELESCOPE_USING(x) ( 9 / ( x ) == 1 )

// Device categories & types
#if defined IS_PS4 || defined (__ORBIS__)
#define TELESCOPE_PS_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_PS4_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_PS5_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB3_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PC_PROGRAM		__TELESCOPE_NOT_IN_USE__
#elif defined IS_PS5 || defined( __GEMINI__ )
#define TELESCOPE_PS_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_PS4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS5_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_XB_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB3_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PC_PROGRAM		__TELESCOPE_NOT_IN_USE__
#elif defined IS_XB3 || defined (_GAMING_XBOX_XBOXONE)
#define TELESCOPE_PS_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS5_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_XB3_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_XB4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PC_PROGRAM		__TELESCOPE_NOT_IN_USE__
#elif defined IS_XB4 || defined (_GAMING_XBOX_SCARLETT)
#define TELESCOPE_PS_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS5_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_XB3_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB4_PROGRAM		__TELESCOPE_IN_USE__
#define TELESCOPE_PC_PROGRAM		__TELESCOPE_NOT_IN_USE__
#elif defined IS_PC || defined( WIN64 )
#define TELESCOPE_PS_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PS5_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB3_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_XB4_PROGRAM		__TELESCOPE_NOT_IN_USE__
#define TELESCOPE_PC_PROGRAM		__TELESCOPE_IN_USE__
#endif

// Console devices
#define TELESCOPE_CONSOLE_PROGRAM	__TELESCOPE_USE_IF__( TELESCOPE_USING(TELESCOPE_PS_PROGRAM) || TELESCOPE_USING(TELESCOPE_XB_PROGRAM) )

// Manufacturer platforms
#define TELESCOPE_MICROSOFT_PROGRAM	__TELESCOPE_USE_IF__( TELESCOPE_USING(TELESCOPE_PC_PROGRAM) || TELESCOPE_USING(TELESCOPE_XB_PROGRAM) )
#define TELESCOPE_SONY_PROGRAM		__TELESCOPE_USE_IF__( TELESCOPE_USING(TELESCOPE_PS_PROGRAM) )

// Features
#ifdef IS_DEVELOPMENT
#define TELESCOPE_DEV				__TELESCOPE_IN_USE__
#else
#define TELESCOPE_DEV				__TELESCOPE_NOT_IN_USE__
#endif

#define TELESCOPE_FEATURE_ASSERT	__TELESCOPE_IN_USE__
#define TELESCOPE_MEMORY_TRACING	TELESCOPE_DEV

#ifdef _MSC_VER
#define TELESCOPE_FORCE_INLINE __forceinline
#define TELESCOPE_NEVER_INLINE __declspec( noinline )
#elif defined( __clang__ ) || defined( __GNUC__ )
#define TELESCOPE_FORCE_INLINE inline __attribute__( ( __always_inline__ ) )
#define TELESCOPE_NEVER_INLINE __attribute__( ( __noinline__ ) )
#else
#error "Unknown compiler"
#endif