/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once
#include "RenderBaseTypes.h"
#include "HardwareSurfaceBase.h"
namespace Telescope
{
	class HardwareRenderBase
	{
	public:
		HardwareRenderBase(){};
		virtual ~HardwareRenderBase(){};

		// Create a CPU-writable texture surface
		virtual HardwareSurfaceBase* CreateTexture() = 0;
		// Create a GPU-blitted texture as render target
		virtual HardwareSurfaceBase* CreateRenderTarget() = 0;
		// Delete an existing hardware surface
		virtual void DeleteSurface( HardwareSurfaceBase* surface ) = 0;
		// Get current binding surface
		virtual HardwareSurfaceBase* GetRenderTarget() = 0;
		// Bind a render surface a render target
		virtual void SetRenderTarget( HardwareSurfaceBase& surface ) = 0;
		// Draw an existing texture to current render target
		virtual void DrawSurface( const HardwareSurfaceBase& surface, const TSFloatRect& targetRect, 
								const TSFloatPoint& offset, const TSFloatSize& scale, float rotate, float opacity ) = 0;
		// Draw border
		virtual void DrawBorder( const TSColor& color, int width, const TSFloatRect& rect, const TSFloatPoint& offset, 
								const TSFloatSize& scale, float rotate) = 0;
		// Fill a rectangle area with solid color
		virtual void Fill( const TSColor& color, const TSFloatRect& targetRect, const TSFloatPoint& offset ) = 0;
		// Clear current render target
		virtual void ClearColor( const TSColor& color ) = 0;
		// Set scissor for current render target
		virtual void ScissorClip( const TSIntRect& scissorBox ) = 0;
		// Upload pixel data to a surface.
		virtual void Tex2DSubData( const HardwareSurfaceBase& surface, const void* data, const TSIntRect& targetRect,
								const TSIntPoint& sourceOffset, int stride ) = 0;

		// Called before issue render command listed above, return false if render is not ready
		virtual bool PrepareRendering() = 0;
		// Called just before issue rendering command
		virtual void BeginRendering() = 0;
		// Called when finished issue rendering command
		virtual void EndRendering() = 0;

		virtual void DrawStencil(unsigned stencilIndex, const TSFloatRect& targetRect, const TSFloatPoint& offset, const TSFloatSize& scale, float rotate) = 0;
		virtual void ClearStencil(unsigned value) = 0;
		virtual void StencilClipAgainstValue(unsigned stencilIndex) = 0;
	};
}