/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once
namespace Telescope
{
	class TSColor
	{
	public:
		TSColor() = default;
		TSColor( int r, int g, int b, int a )
		{
			m_color |= a << 24;
			m_color |= r << 16;
			m_color |= g << 8;
			m_color |= b;
		}

		int Red() const { return m_color >> 16 & 0xff; };
		int Green() const { return m_color >> 8 & 0xff; };
		int Blue() const { return m_color & 0xff; };
		int Alpha() const { return m_color >> 24 & 0xff; };

		void getRGBA( float& r, float& g, float& b, float& a ) const
		{
			r = (float)Red() / 255.0f;
			g = (float)Green() / 255.0f;
			b = (float)Blue() / 255.0f;
			a = (float)Alpha() / 255.0f;
		}

#ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
		template<typename TWebCoreColor>
		TSColor( const TWebCoreColor& color )
			:m_color( color.rgb() )
		{
		}

		template<typename TWebCoreColor>
		TSColor& operator=(const TWebCoreColor& color )
		{
			m_color = color.rgb();
			return *this;
		}
		
#endif // #ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
	private:
		unsigned m_color { 0 };
	};

	template<typename T>
	class TSPointBase
	{
	public:
		TSPointBase() = default;
		TSPointBase( T x, T y )
			:m_x( x )
			, m_y( y )
		{
		}
		T x() const { return m_x; }
		T y() const { return m_y; }

#ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
		template<typename TWebCorePoint>
		TSPointBase( const TWebCorePoint& point )
			:TSPointBase( point.x(), point.y() )
		{
		}

		template<typename TWebCorePoint>
		TSPointBase& operator=( const TWebCorePoint& point )
		{
			m_x = point.x();
			m_y = point.y();
			return *this;
		}
#endif // #ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY

	protected:
		T m_x { 0 };
		T m_y { 0 };
	};

	template<typename T>
	class TSSizeBase
	{
	public:
		TSSizeBase() = default;
		TSSizeBase( T width, T height )
			:m_width( width )
			, m_height( height )
		{
		}
		T width() const { return m_width; }
		T height() const { return m_height; }

#ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
		template<typename TWebCoreSize>
		TSSizeBase( const TWebCoreSize& size )
			:TSSizeBase( size.width(), size.height() )
		{
		}

		template<typename TWebCoreSize>
		TSSizeBase& operator=( const TWebCoreSize& size )
		{
			m_width = size.width();
			m_height = size.height();
			return *this;
		}
#endif // #ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
	protected:
		T m_width { 0 };
		T m_height { 0 };
	};

	template<typename T>
	class TSRectBase
	{
	public:
		TSRectBase() = default;
		TSRectBase( T x, T y, T width, T height )
			:m_x( x ), m_y( y )
			,m_width( width ), m_height( height )
		{
		}
		T x() const { return m_x; }
		T y() const { return m_y; }
		T width() const { return m_width; }
		T height() const { return m_height; }

#ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
		template<typename TWebCoreRect>
		TSRectBase( const TWebCoreRect& rect )
			:TSRectBase( rect.x(), rect.y(), rect.width(), rect.height() )
		{
		}

		template<typename TWebCoreRect>
		TSRectBase& operator=( const TWebCoreRect& rect )
		{
			m_x = rect.x();
			m_y = rect.y();
			m_width = rect.width();
			m_height = rect.height();
			return *this;
		}
#endif // #ifdef USE_WEBCORE_TYPE_CONVERTION_UTILITY
	protected:
		T m_x {0};
		T m_y {0};
		T m_width {0};
		T m_height {0};
	};

	typedef TSPointBase<int> TSIntPoint;
	typedef TSPointBase<float> TSFloatPoint;
	typedef TSSizeBase<int> TSIntSize;
	typedef TSSizeBase<float> TSFloatSize;
	typedef TSRectBase<int> TSIntRect;
	typedef TSRectBase<float> TSFloatRect;
}