/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

namespace Telescope::Errors
{
	//
	// Design Principles
	//
	// 1. Telescope error codes is inspired by Windows System Error Codes.
	//    The names (and their meaning) are similar to the ones in Windows error codes, but with the 'ERROR_' prefix removed.
	//    Please refer to https://docs.microsoft.com/en-us/windows/win32/debug/system-error-codes for Windows error codes.
	//
	// 2. An error code represents a type of error. An error message carries more information about the error.
	//    Telescope reserves the range [1, MAX_COMMON_ERROR_CODE] for all predefined common errors that are used by Telescope itself.
	//    A client library can define its own error codes starting from (MAX_COMMON_ERROR_CODE + 1).
	//
	// 3. Before adding a new error code, please go through the existing error codes to avoid duplicates.
	//    It is preffered to use the existing error codes if there is one with the similar purpose.
	//    If there is not one, please check out the Windows error codes to choose one with a proper meaning for your case.
	//    If there is not a proper one in Windows error codes, then to create your specific one.
	//
	// 4. Generic names like 'system error' or 'runtime error' should be avoided, as they do not provide enough information about errors.


	//
	// Telescope common error codes
	//

	const unsigned int
		// Inspired from Windows
		FILE_NOT_FOUND = 1,
		ACCESS_DENIED = 2,
		INVALID_HANDLE = 3,
		NOT_ENOUGH_MEMORY = 4,
		INVALID_DATA = 5,
		NOT_SUPPORTED = 6,
		INVALID_PARAMETER = 7,
		INVALID_NAME = 8,
		INVALID_ADDRESS = 9,

		// Specific
		INVALID_CALL = 100, // A method/function call is invalid for the object's current state, or within an incorrect call order.
		THIRDPARTY_CALL_FAILED = 101, // Getting a failed result from a thirdparty function, and we don't know exactly why it happens.
		OUT_OF_BUFFER = 102, // The size of data is larger than the max size of the buffer that we expected to receive the data.
		UNEXPECTED_SWITCH_CASE = 103, // There is an unexpected case in a switch-case statement, falling into the 'default' clause.

		// The max value of common error codes
		MAX_COMMON_ERROR_CODE = 1000;
}