/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef TELESCOPELIB_INCLUDE
#define TELESCOPELIB_INCLUDE

#include "JSONInterfaces.h"

class CompressionWrapperBase;
namespace Telescope
{
	class IMemoryAllocator;
	class HttpWrapperBase;
	class HashingWrapperBase;
	class CryptoWrapperBase;
	class AssetLoaderWrapperBase;
	class LogWrapperBase;
	class SystemAPIWrapperBase;
	class ErrorHandlingWrapperBase;
	class WebView;
	class IMemoryScopeTracker;

	class TelescopeConfig
	{
	public:
		IMemoryAllocator* m_pMemAllocator;
		// TODO: looks like the naming conversion is not unified between IMemoryAllocator and HttpWrapperInterface.
		HttpWrapperBase* m_pHttpWrapper;
		// TODO: CompressionWrapperBase should be wrapped by namespace Telescope
		CompressionWrapperBase* m_pCompressionImpl;
		HashingWrapperBase* m_pHashingImpl;
		CryptoWrapperBase* m_pCryptoImpl;
		AssetLoaderWrapperBase* m_pAssetLoaderImpl;
		LogWrapperBase* m_pLogImpl;
		SystemAPIWrapperBase* m_pSysAPIImpl;
		ErrorHandlingWrapperBase* m_pErrorHandlingImpl;

		TelescopeConfig()
			: m_pMemAllocator(nullptr)
			, m_pHttpWrapper(nullptr)
			, m_pCompressionImpl(nullptr)
			, m_pHashingImpl(nullptr)
			, m_pCryptoImpl(nullptr)
			, m_pAssetLoaderImpl(nullptr)
			, m_pLogImpl(nullptr)
			, m_pSysAPIImpl(nullptr)
			, m_pErrorHandlingImpl(nullptr)
		{}
	};

	class TelescopeLib
	{
	public:
		virtual void PreInit( TelescopeConfig* config );
		virtual bool Init( TelescopeConfig* config );
		virtual void Shutdown();

		virtual void Tick();

		virtual WebView* CreateView();
		virtual void DestroyView( WebView* view );

		virtual bool InstallFont( const unsigned char* fontData, size_t dataSize );

		virtual void InitFileCache(const char *cacheDirectory, size_t storageSizeLimitInBytes);

		virtual unsigned int getTelescopeCL();

		// JSON Factory method
		virtual JsonWrapper::ValuePtr ParseJson(const char* pJsonInput, size_t jsonLength = 0);

		virtual IMemoryScopeTracker& GetMemoryScopeTracker();
	};
}
#endif
