/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#pragma once

#include <WebCore/BridgeJSC.h>
#include <WebCore/runtime_method.h>
#include <wtf/Assertions.h>
#include <JavaScriptCore/JSCJSValue.h>
#include <wtf/Noncopyable.h>

namespace JSC
{
	namespace Bindings
	{
		//////////////////////////////////////////////////////////////////////////
		//	TelescopeClass
		class TelescopeClass : public Class
		{
			WTF_MAKE_NONCOPYABLE( TelescopeClass );
		protected:
			TelescopeClass();

		public:
			//	override virtual method
			virtual Method* methodNamed( PropertyName oPropertyName, Instance* pInst ) const override;
			virtual Field* fieldNamed( PropertyName oPropertyName, Instance* pInst ) const override;

		public:
			virtual ~TelescopeClass();

			static TelescopeClass* ClassForInstance( const Instance* pInst );
			static void Finalize();

		private:
			mutable HashMap<RefPtr<StringImpl>, std::unique_ptr<Method>> m_mMethods;
			mutable HashMap<RefPtr<StringImpl>, std::unique_ptr<Field>> m_mFields;
		};

		//////////////////////////////////////////////////////////////////////////
		//	TelescopeField
		class TelescopeField : public Field
		{
		public:
			TelescopeField( const char* pID );

		public:
			//	override virtual method
			virtual JSValue valueFromInstance( JSGlobalObject*, const Instance* ) const override;
			virtual bool setValueToInstance( JSGlobalObject*, const Instance*, JSValue ) const override;

			const char* GetName();

		private:
			WTF::String m_sIdent;
		};


		//////////////////////////////////////////////////////////////////////////
		//	TelescopeMethod
		class TelescopeMethod : public Method
		{
		public:
			TelescopeMethod( const char* pID ) ;

		public:
			//	override virtual method
			virtual int numParameters() const override;

			const char* TelescopeName();

		private:
			WTF::String m_sIdent;
		};


		//////////////////////////////////////////////////////////////////////////
		//	TelescopeRuntimeMethod
		class TelescopeRuntimeMethod : public RuntimeMethod
		{
			DECLARE_INFO

		public:
			static TelescopeRuntimeMethod* create( JSGlobalObject* pGlobalObject, const String& rName, Bindings::Method* pMethod );
			static Structure* createStructure( VM& rVM, JSGlobalObject* pGlobalObject, JSValue oVal );

		private:
			TelescopeRuntimeMethod( JSGlobalObject* pGlobalObject, Structure* pStructure, Bindings::Method* pMethod );
			void finishCreation( VM& rVM, const String& rName );
		};
	}
}
