/*
 * Copyright (C) 2020 Activision Publishing, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 *
 * 3. Neither the name of Activision Publishing, Inc. nor the names of
 *    its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WEBFRAME_H_INCLUDE
#define WEBFRAME_H_INCLUDE

#include <wtf/Ref.h>
#include <wtf/URL.h>
#include "ClientWrappers/MemoryAllocatorBase.h"
#include "TelescopeJSBoundObject.h"
#include "TelescopeJavascriptValue.h"

namespace WebCore
{
	class Frame;
	class Page;
	class HTMLFrameOwnerElement;
};

class WebFrame;
namespace Telescope
{
class WebView;
}

WebCore::Frame* core(WebFrame*);

class WebFrame
{
public:
	WebFrame();
	virtual ~WebFrame();
	::Telescope::WebView* webView() const;

	static WebFrame* createInstance();

	Ref<WebCore::Frame> createSubframeWithOwnerElement(::Telescope::WebView* view, WebCore::Page* page, WebCore::HTMLFrameOwnerElement*);

	void initWithWebView(::Telescope::WebView* view, WebCore::Page* page);

	WebCore::Frame* frameView() { return mFrame; };

	void loadRequest(WTF::URL* url);

	void AddToJavaScriptWindowObject( const char* pName, Telescope::IJSBoundObject* pObj );	
	Telescope::TelescopeJSValue* CreateJavaScriptValue();
	void DestroyJavaScriptValue( Telescope::TelescopeJSValue* value );

private:
	WebCore::Frame* mFrame;
	::Telescope::WebView* mWebView;
};
#endif