#pragma once

#include "PlatformFeatureDefs.h"

#if TELESCOPE_USING(TELESCOPE_PC_PROGRAM) || TELESCOPE_USING(TELESCOPE_XB_PROGRAM)
#include <windows.h>
#endif

#include <JavaScriptCore/JSExportMacros.h>
#include <WebCore/PlatformExportMacros.h>
#include <pal/ExportMacros.h>

#ifdef __cplusplus

// These undefs match up with defines in WebCorePrefix.h for Mac OS X.
// Helps us catch if anyone uses new or delete by accident in code and doesn't include "config.h".
#undef new
#undef delete
#include <wtf/FastMalloc.h>

#endif

#include "webkit.h"

#ifdef SONY_PLATFORM
#include <sys/_types.h>
#include <yvals.h>
#include <stdlib.h>
typedef	__size_t	size_t;
#define BOOL bool
#endif

// Telescope.dll is expected to export the symbols in WebCore that have been marked
// as WEBCORE_EXPORT
#undef WEBCORE_EXPORT
#define WEBCORE_EXPORT